package gov.va.med.mhv.journal.service;

import java.util.List;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;

public interface FoodJournalService {

	public List<FoodJournalDTO> findFoodJournalsForUser(Long userProfileId) throws MHVException;

	public List<FoodJournalDTO> getFoodJournalsForDashBoard(Long userProfileId) throws MHVException;

	public FoodJournalDTO findFoodJournalById(Long foodJournalId) throws MHVException;

	public MealItemDTO getMealItemById(Long mealItemId) throws MHVException;

	public MealItemDTO addMealItem(MealItemDTO mealItemDTO) throws MHVException;

	public FoodJournalDTO addFoodJournal(FoodJournalDTO foodJournalDTO) throws MHVException;

	public void deleteFoodJournal(Long foodJournalId) throws MHVException;

	public void deleteMealItem(Long mealItemId) throws MHVException;
}
